/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.model.impl;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.resources.IUniformResource;
import com.aptana.core.util.IOUtil;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.core.model.IMethod;
import com.aptana.editor.php.core.model.IModelElement;
import com.aptana.editor.php.core.model.ISourceModule;
import com.aptana.editor.php.core.model.IType;
import com.aptana.editor.php.core.model.env.ModelElementInfo;
import com.aptana.editor.php.indexer.IElementEntry;
import com.aptana.editor.php.indexer.IElementsIndex;
import com.aptana.editor.php.indexer.PHPGlobalIndexer;
import com.aptana.editor.php.internal.builder.FileSystemModule;
import com.aptana.editor.php.internal.builder.LocalModule;
import com.aptana.editor.php.internal.core.builder.IBuildPath;
import com.aptana.editor.php.internal.core.builder.IBuildPathResource;
import com.aptana.editor.php.internal.core.builder.IModule;
import com.aptana.editor.php.internal.model.impl.AbstractResourceElement;
import com.aptana.editor.php.internal.model.utils.ModelUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org2.eclipse.dltk.internal.core.util.Util;

public class SourceModule
extends AbstractResourceElement
implements ISourceModule {
    private static final char[] EMPTY_CONTENT = new char[0];

    public SourceModule(IModule module) {
        super((IBuildPathResource)module);
    }

    public int getElementType() {
        return 5;
    }

    public List<IModelElement> getChildren() {
        IElementsIndex index = PHPGlobalIndexer.getInstance().getIndex();
        List<IElementEntry> entries = index.getModuleEntries(this.getModule());
        ArrayList<IModelElement> result = new ArrayList<IModelElement>();
        for (IElementEntry entry : entries) {
            IModelElement element;
            String pathStr = entry.getEntryPath();
            if (pathStr == null || pathStr.contains(Character.toString('/')) || (element = ModelUtils.convertEntry(entry)) == null) continue;
            result.add(element);
        }
        return result;
    }

    public boolean hasChildren() {
        return this.getChildren().size() > 0;
    }

    public Object getResource() {
        IModule module = this.getModule();
        if (module instanceof LocalModule) {
            return ((LocalModule)module).getFile();
        }
        if (module instanceof FileSystemModule) {
            FileSystemModule fsm = (FileSystemModule)module;
            if (fsm.isInWorkspace()) {
                IPath iPath = Path.fromOSString((String)fsm.getFullPath());
                return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(iPath);
            }
            return fsm.getExternalFile();
        }
        return null;
    }

    protected IModule getModule() {
        return (IModule)this.getBPResource();
    }

    public List<IType> getTopLevelTypes() {
        List<IModelElement> chidren = this.getChildren();
        ArrayList<IType> result = new ArrayList<IType>();
        for (IModelElement child : chidren) {
            if (!(child instanceof IType)) continue;
            result.add((IType)child);
        }
        return result;
    }

    public String getPath() {
        Object resource = this.getResource();
        if (resource == null) {
            return null;
        }
        if (resource instanceof IResource) {
            return ((IResource)resource).getProjectRelativePath().toPortableString();
        }
        return ((IUniformResource)resource).getURI().toString();
    }

    public List<IMethod> getTopLevelMethods() {
        List<IModelElement> chidren = this.getChildren();
        ArrayList<IMethod> result = new ArrayList<IMethod>();
        this.getMethodsRecursively(chidren, result, 3);
        return result;
    }

    private void getMethodsRecursively(List<IModelElement> chidren, List<IMethod> result, int depth) {
        for (IModelElement child : chidren) {
            if (child instanceof IMethod) {
                result.add((IMethod)child);
                continue;
            }
            if (!(child instanceof IType) || depth <= 0) continue;
            IType type = (IType)child;
            this.getMethodsRecursively(type.getChildren(), result, --depth);
        }
    }

    public IType getType(String name) {
        for (IType t : this.getTopLevelTypes()) {
            if (!t.getElementName().equals(name)) continue;
            return t;
        }
        return null;
    }

    public ISourceModule getModule(String include) {
        Path path = new Path(include);
        IModule module = this.getModule();
        IBuildPath buildPath = module.getBuildPath();
        IModule includedModule = buildPath.resolveRelativePath(module, (IPath)path);
        if (includedModule != null) {
            return ModelUtils.convertModule(includedModule);
        }
        return null;
    }

    @Override
    public ModelElementInfo getElementInfo() {
        ModelElementInfo info = new ModelElementInfo();
        List<IModelElement> children = this.getChildren();
        if (children != null && children.size() != 0) {
            info.setChildren(children);
        }
        return info;
    }

    public char[] getSourceAsCharArray() throws CoreException {
        Object resource = this.getResource();
        IFile file = null;
        if (resource instanceof IFile) {
            file = (IFile)resource;
        }
        if (file == null) {
            File f = new File(this.getModule().getFullPath());
            if (!f.exists()) {
                throw new IllegalStateException("Source module resource was null");
            }
            try {
                return IOUtil.read((InputStream)new FileInputStream(f)).toCharArray();
            }
            catch (FileNotFoundException e) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.editor.php", "Error reading the file's content", (Throwable)e));
            }
        }
        if (!file.exists()) {
            throw new IllegalStateException("Source module resource does not exist");
        }
        try {
            return Util.getResourceContentsAsCharArray((IFile)file, (String)file.getCharset());
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error getting a source content as char-array", (Throwable)e, (String)"com.aptana.editor.php/debug");
            return EMPTY_CONTENT;
        }
    }
}

